%------------------------------------------------------------------------------
% File     : LCL716^1 : TPTP v9.2.0. Bugfixed v5.0.0.
% Domain   : Logic Calculi (Quantified multimodal logic)
% Problem  : Axiom implies accessibility relation for weak density
% Version  : [Ben09] axioms.
% English  :

% Refs     : [Gol92] Goldblatt (1992), Logics of Time and Computation
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
% Source   : [Ben09]
% Names    : ex32_22.p [Ben09]

% Status   : Theorem
% Rating   : 0.44 v9.1.0, 0.50 v8.2.0, 0.69 v8.1.0, 0.55 v7.5.0, 0.57 v7.4.0, 0.78 v7.2.0, 0.75 v7.0.0, 0.71 v6.4.0, 0.67 v6.3.0, 0.60 v6.2.0, 0.57 v6.1.0, 0.43 v5.5.0, 0.67 v5.4.0, 0.80 v5.3.0, 1.00 v5.2.0, 0.80 v5.0.0
% Syntax   : Number of formulae    :   64 (  31 unt;  32 typ;  31 def)
%            Number of atoms       :   99 (  36 equ;   0 cnn)
%            Maximal formula atoms :    7 (   3 avg)
%            Number of connectives :  135 (   4   ~;   4   |;   8   &; 110   @)
%                                         (   0 <=>;   9  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :  171 ( 171   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   38 (  36 usr;   6 con; 0-3 aty)
%            Number of variables   :   86 (  50   ^;  30   !;   6   ?;  86   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
% Bugfixes : v5.0.0 - Bugfix to LCL013^0.ax
%------------------------------------------------------------------------------
%----Include embedding of quantified multimodal logic in simple type theory
include('Axioms/LCL013^0.ax').
%------------------------------------------------------------------------------
thf(conj,conjecture,
    ! [R: $i > $i > $o] :
      ( ( mvalid
        @ ( mforall_prop
          @ ^ [A: $i > $o] : ( mimplies @ ( mbox @ R @ ( mbox @ R @ A ) ) @ ( mbox @ R @ A ) ) ) )
     => ( mweakly_dense @ R ) ) ).

%------------------------------------------------------------------------------
